
package GttMatch;

import java.awt.*;
import java.awt.event.*;
import java.io.PrintStream;
import java.util.EventObject;
import javax.swing.*;
import javax.swing.text.JTextComponent;

// Referenced classes of package GttMatch:
//            ImagePanel, MatchApp

public class GttMatch extends JFrame
{
    class SymWindow extends WindowAdapter
    {

        public void windowClosing(WindowEvent windowevent)
        {
            Object obj = windowevent.getSource();
            if(obj == GttMatch.this)
                GttMatch_windowClosing(windowevent);
        }

        SymWindow()
        {
        }
    }

    class SymAction
        implements ActionListener
    {

        public void actionPerformed(ActionEvent actionevent)
        {
            Object obj = actionevent.getSource();
            if(obj == JButtonFile1)
                JButtonFile1_actionPerformed(actionevent);
            else
            if(obj == JButtonFile2)
                JButtonFile2_actionPerformed(actionevent);
            else
            if(obj == JButtonOut)
                JButtonOut_actionPerformed(actionevent);
            else
            if(obj == JButtonRun)
                JButtonRun_actionPerformed(actionevent);
        }

        SymAction()
        {
        }
    }


    public GttMatch()
    {
        frameSizeAdjusted = false;
        saveFileDialog = new FileDialog(this);
        openFileDialog = new FileDialog(this);
        JPanel1 = new JPanel();
        JLabel1 = new JLabel();
        JLabel4 = new JLabel();
        JLabel2 = new JLabel();
        JLabel3 = new JLabel();
        JComboBox1 = new JComboBox();
        JTextField1 = new JTextField();
        JTextField2 = new JTextField();
        JTextField3 = new JTextField();
        JButtonFile1 = new JButton();
        JButtonFile2 = new JButton();
        JButtonOut = new JButton();
        JLabel5 = new JLabel();
        JLabel6 = new JLabel();
        JTextField4 = new JTextField();
        JTextField5 = new JTextField();
        JButtonRun = new JButton();
        JProgressBar1 = new JProgressBar();
        JLabel7 = new JLabel();
        imagePanel = new ImagePanel();
        setTitle("GttMatch");
        setDefaultCloseOperation(0);
        getContentPane().setLayout(new BorderLayout(0, 0));
        setSize(548, 261);
        setVisible(false);
        saveFileDialog.setMode(1);
        saveFileDialog.setTitle("Save");
        openFileDialog.setMode(0);
        openFileDialog.setTitle("Open");
        JPanel1.setLayout(null);
        getContentPane().add("Center", JPanel1);
        JPanel1.setBounds(0, 0, 548, 261);
        JLabel1.setText("Input Data File 1");
        JLabel1.setToolTipText("Enter the first input data file name");
        JPanel1.add(JLabel1);
        JLabel1.setBounds(24, 84, 96, 24);
        JLabel4.setText("Algorithm");
        JLabel4.setToolTipText("Select a matching algorithm");
        JPanel1.add(JLabel4);
        JLabel4.setBounds(24, 36, 96, 24);
        JLabel2.setText("Input Data File 2");
        JLabel2.setToolTipText("Enter the second input data file name");
        JPanel1.add(JLabel2);
        JLabel2.setBounds(24, 120, 96, 24);
        JLabel3.setText("Output Data File");
        JLabel3.setToolTipText("Enter the output data file name");
        JPanel1.add(JLabel3);
        JLabel3.setBounds(24, 156, 96, 24);
        JComboBox1.setToolTipText("Select a matching algorithm");
        JPanel1.add(JComboBox1);
        JComboBox1.setBounds(120, 36, 180, 24);
        JTextField1.setText("D:\\GT\\data\\gpcu.fsa");
        JTextField1.setToolTipText("Enter the first input data file name");
        JPanel1.add(JTextField1);
        JTextField1.setBounds(120, 84, 252, 24);
        JTextField2.setText("D:\\GT\\data\\gpcu.fsa");
        JTextField2.setToolTipText("Enter the second input data file name");
        JPanel1.add(JTextField2);
        JTextField2.setBounds(120, 120, 252, 24);
        JTextField3.setText("D:\\GT\\data\\output.txt");
        JTextField3.setToolTipText("Enter the output data file name");
        JPanel1.add(JTextField3);
        JTextField3.setBounds(120, 156, 252, 24);
        JButtonFile1.setText("...");
        JButtonFile1.setActionCommand("...");
        JButtonFile1.setToolTipText("Enter the first input data file name");
        JPanel1.add(JButtonFile1);
        JButtonFile1.setBounds(384, 84, 24, 24);
        JButtonFile2.setText("...");
        JButtonFile2.setActionCommand("...");
        JButtonFile2.setToolTipText("Enter the second input data file name");
        JPanel1.add(JButtonFile2);
        JButtonFile2.setBounds(384, 120, 24, 24);
        JButtonOut.setText("...");
        JButtonOut.setActionCommand("...");
        JButtonOut.setToolTipText("Enter the output data file name");
        JPanel1.add(JButtonOut);
        JButtonOut.setBounds(384, 156, 24, 24);
        JLabel5.setText("Strings");
        JLabel5.setToolTipText("How many first strings from the first file to use");
        JPanel1.add(JLabel5);
        JLabel5.setBounds(432, 84, 48, 24);
        JLabel6.setText("Strings");
        JLabel6.setToolTipText("How many first strings from the second file to use");
        JPanel1.add(JLabel6);
        JLabel6.setBounds(432, 120, 48, 24);
        JTextField4.setText("1");
        JTextField4.setToolTipText("How many first strings from the first file to use");
        JPanel1.add(JTextField4);
        JTextField4.setBounds(480, 84, 44, 24);
        JTextField5.setText("100");
        JTextField5.setToolTipText("How many first strings from the second file to use");
        JPanel1.add(JTextField5);
        JTextField5.setBounds(480, 120, 44, 24);
        JButtonRun.setText("Start");
        JButtonRun.setActionCommand("Run");
        JButtonRun.setToolTipText("Start running the algorithm");
        JPanel1.add(JButtonRun);
        JButtonRun.setBounds(432, 156, 92, 24);
        JProgressBar1.setStringPainted(true);
        JPanel1.add(JProgressBar1);
        JProgressBar1.setBounds(24, 204, 500, 8);
        JLabel7.setText("Copyright 2001 (C) GreenTea Technologies, Inc.");
        JPanel1.add(JLabel7);
        JLabel7.setBounds(252, 228, 276, 24);
        SymAction symaction = new SymAction();
        JButtonFile1.addActionListener(symaction);
        JButtonFile2.addActionListener(symaction);
        JButtonOut.addActionListener(symaction);
        JButtonRun.addActionListener(symaction);
        SymWindow symwindow = new SymWindow();
        addWindowListener(symwindow);
        JComboBox1.addItem("Smith Waterman");
        JComboBox1.addItem("Blast");
        JComboBox1.setSelectedItem("Smith Waterman");
        JPanel1.add(imagePanel);
        imagePanel.setBounds(396, 12, 120, 60);
    }

    public GttMatch(String s)
    {
        this();
        setTitle(s);
    }

    public static void main(String args[])
    {
        if(args.length == 0)
            try
            {
                (new GttMatch()).setVisible(true);
            }
            catch(Throwable throwable)
            {
                throwable.printStackTrace();
                System.exit(1);
            }
        else
        if(args.length == 5)
            try
            {
                int i = Integer.parseInt(args[1]);
                int j = Integer.parseInt(args[3]);
                if(i < 1 || j < 1)
                    usage();
                Thread thread = new Thread(new MatchApp(null, null, args[0], i, args[2], j, args[4]));
                thread.start();
            }
            catch(NumberFormatException numberformatexception)
            {
                usage();
            }
        else
            usage();
    }

    public void addNotify()
    {
        Dimension dimension = getSize();
        super.addNotify();
        if(frameSizeAdjusted)
            return;
        frameSizeAdjusted = true;
        javax.swing.JMenuBar jmenubar = getRootPane().getJMenuBar();
        int i = 0;
        if(jmenubar != null)
            i = jmenubar.getPreferredSize().height;
        Insets insets = getInsets();
        setSize(insets.left + insets.right + dimension.width, insets.top + insets.bottom + dimension.height + i);
    }

    void JButtonFile1_actionPerformed(ActionEvent actionevent)
    {
        FileDialog filedialog = new FileDialog(this, "Open First Data File", 0);
        filedialog.setDirectory(".");
        filedialog.show();
        if(filedialog.getFile() != null)
            JTextField1.setText(filedialog.getDirectory() + filedialog.getFile());
    }

    void JButtonFile2_actionPerformed(ActionEvent actionevent)
    {
        FileDialog filedialog = new FileDialog(this, "Open Second Data File", 0);
        filedialog.setDirectory(".");
        filedialog.show();
        if(filedialog.getFile() != null)
            JTextField2.setText(filedialog.getDirectory() + filedialog.getFile());
    }

    void JButtonOut_actionPerformed(ActionEvent actionevent)
    {
        FileDialog filedialog = new FileDialog(this, "Open Output Data File", 1);
        filedialog.setDirectory(".");
        filedialog.show();
        if(filedialog.getFile() != null)
            JTextField3.setText(filedialog.getDirectory() + filedialog.getFile());
    }

    void JButtonRun_actionPerformed(ActionEvent actionevent)
    {
        if(JTextField1.getText().length() == 0 || JTextField2.getText().length() == 0 || JTextField3.getText().length()             return;
        int i;
        int j;
        try
        {
            i = Integer.parseInt(JTextField4.getText());
            j = Integer.parseInt(JTextField5.getText());
        }
        catch(NumberFormatException numberformatexception)
        {
            return;
        }
        Thread thread = new Thread(new MatchApp(JProgressBar1, JButtonRun, JTextField1.getText(), i,         thread.start();
        JButtonRun.setEnabled(false);
    }

    private static void usage()
    {
        System.out.println("Usage:");
        System.out.println("\tjava GttMatch.GttMatch [<DataFile1> <n1> <DataFile2> <n2> ResultFile]");
        System.out.println("\t<DataFile1>, <DataFile2>: Data file names");
        System.out.println("\t<n1>, <n2>: Numbers of strings to use");
        System.out.println("\t<ResultFile>: A file to save output results");
        System.out.println("");
        System.out.println("Example:");
        System.out.println("\tjava GttMatch.GttMatch");
        System.out.println("\tjava GttMatch.GttMatch file1.dat 100 file2.dat 200 results.txt");
        System.exit(1);
    }

    void GttMatch_windowClosing(WindowEvent windowevent)
    {
        System.exit(0);
    }

    boolean frameSizeAdjusted;
    FileDialog saveFileDialog;
    FileDialog openFileDialog;
    JPanel JPanel1;
    JLabel JLabel1;
    JLabel JLabel4;
    JLabel JLabel2;
    JLabel JLabel3;
    JComboBox JComboBox1;
    JTextField JTextField1;
    JTextField JTextField2;
    JTextField JTextField3;
    JButton JButtonFile1;
    JButton JButtonFile2;
    JButton JButtonOut;
    JLabel JLabel5;
    JLabel JLabel6;
    JTextField JTextField4;
    JTextField JTextField5;
    JButton JButtonRun;
    JProgressBar JProgressBar1;
    JLabel JLabel7;
    ImagePanel imagePanel;
}


